/*
  This file is part of Universal USB Installer

  It is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with it. If not, see <https://www.gnu.org/licenses/>.

  Copyright https://pendrivelinux.com (See UUI-Copying.txt and UUI-Readme.txt for more information, Credits, and Licensing)
*/
 
; ------------ Install Distros Macro -------------- 

!macro Install_Distros 

; If distro is already installed, delete it, so we don't make a mess.
${If} ${FileExists} "$BootDir\UUI\$DistroPath\$JustISO"
 StrCpy $DistroName "$DistroPath\$JustISO"
 ;MessageBox MB_OK "$DistroName"
 StrCpy $PersistName "$DistroName" -4
  Push $PersistName
  Call ConvertBStoFS
  Pop $R0
  StrCpy $PersistName2 $R0
  StrCpy $DELPERSIST '{"image": "/UUI/$PersistName2.iso","backend": "/UUI/$PersistName2.rw"},'
    Delete "$BootDir\UUI\$DistroPath\$JustISO" 
    ${LineFind} "$BootDir\UUI\Installed.txt" "$BootDir\UUI\Installed.txt" "1:-1" "DeleteInstalled" ; Remove the Installed entry
    ${LineFind} "$BootDir\UUI\Installed.txt" "$BootDir\UUI\Installed.txt" "1:-1" "DeleteEmptyLine" ; Remove any left over empty lines
    DetailPrint "The Distro $DistroName was removed!"
   ${If} ${FileExists} "$BootDir\UUI\$PersistName.rw" ; Persistence file also exists.
	 MessageBox MB_YESNO|MB_ICONQUESTION "Would you like to also remove the persistence entry$\r$\nand related file $PersistName.rw?" IDYES removeit
	 Goto skipremoval
	 removeit:
     Delete "$BootDir\UUI\$PersistName.rw" 

      ${If} ${FileExists} "$BootDir\ventoy\*.*"
       StrCpy $JsonPath "ventoy"
      ${Else}
       StrCpy $JsonPath "UUI"
      ${EndIf}

     !insertmacro ReplaceInFile "$DELPERSIST" "" "all" "all" "$BootDir\$JsonPath\ventoy.json" 
	 !insertmacro ReplaceInFile "$DELPERSIST2" "" "all" "all" "$BootDir\$JsonPath\ventoy.json" 
     ${LineFind} "$BootDir\$JsonPath\ventoy.json" "$BootDir\$JsonPath\ventoy.json" "1:-1" "DeleteEmptyLine" ; Remove any left over empty lines  
	 DetailPrint "The persistence file $PersistName.rw was also removed!"
	 skipremoval:
   ${EndIf}
${EndIf}

; Create the Path (container for Distro and persistence if available).
${IfNot} ${FileExists} "$BootDir\UUI\$DistroPath\*.*"
  CreateDirectory "$BootDir\UUI\$DistroPath" ; Create the Directory so we can copy the file to it.
${EndIf}
 
; Do Stuff with Distro 
${If} $DistroName != "" 
; Distro Specific
; Run Windows on VHDx (Virtual Hard Disk) from USB
${AndIf} $DistroName == "Phoenix LiteOS" 
${OrIf} $DistroName == "Windows X-Lite" 
 
   ${IfNot} ${FileExists} "$BootDir\Ventoy\ventoy_vhdboot.img"
     ${IfNot} ${FileExists} "$BootDir\Ventoy\*.*"
      CreateDirectory "$BootDir\Ventoy" ; Create the Directory so we can copy the file to it.
     ${EndIf}
     inetc::get /caption "ventoy_vhdboot.zip" /banner "Downloading VHD Boot Plugin" /nocancel "https://github.com/ventoy/vhdiso/releases/latest/download/ventoy_vhdboot.zip"  "$BootDir\ventoy\ventoy_vhdboot.zip" /end
     Pop $0 # return value = exit code, "OK" means OK
     DetailPrint "VHD Download Status: $0"
	 DetailPrint "Extracting ventoy_vhdboot.img" 
	 ExecWait '"$PLUGINSDIR\7zG.exe" x "$BootDir\ventoy\ventoy_vhdboot.zip" -o"$BootDir\ventoy" -y'
	 CopyFiles "$BootDir\ventoy\ventoy_vhdboot\Win10Based\ventoy_vhdboot.img" "$BootDir\ventoy\ventoy_vhdboot.img"
	 RMDir /R "$BootDir\ventoy\ventoy_vhdboot"
	 Delete "$BootDir\ventoy\ventoy_vhdboot.zip"
   ${EndIf}
   	 CreateDirectory "$EXEDIR\TEMPUUI" ; Create the TEMPUUI directory
	 
	 ${If} $Casper != "0"
	  StrCpy $VHDSize "$Casper" 
	 ${Else}
	  StrCpy $VHDSize "30000" ; Set default VHDx filesize to roughly 30GB
	 ${EndIf}
	 
	 StrCpy $VHDLBL "Win11"
	 
	 !insertmacro ReplaceInFile "DSK" "$EXEDIR\TEMPUUI" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt" ;$BootDir\UUI\$DistroPath
	 !insertmacro ReplaceInFile "SLUG" "$JustISOName" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt" ;Phoenix-LiteOS-PRO
	 !insertmacro ReplaceInFile "DSK" "$EXEDIR\TEMPUUI" "all" "all" "$PLUGINSDIR\diskpartdetach.txt" ;$BootDir\UUI\$DistroPath
	 !insertmacro ReplaceInFile "SLUG" "$JustISOName" "all" "all" "$PLUGINSDIR\diskpartdetach.txt" ;Phoenix-LiteOS-PRO
	 !insertmacro ReplaceInFile "VHDFMT" "ntfs" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt"  ; edit this to format type
	 !insertmacro ReplaceInFile "VHDSIZE" "$VHDSize" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt"  ; edit this to beyond the calculated filesize in bytes
	 !insertmacro ReplaceInFile "VHDLBL" "$VHDLBL" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt"  
	 
	 DetailPrint "Creating a Virtual Hard Disk for Phoenix LiteOS/X-Lite." 
	 nsExec::ExecToLog 'DiskPart /S "$PLUGINSDIR\w2gdiskpart.txt"' 

	 DetailPrint "Installing $JustISOName to Virtual Hard Disk. Please be patient, this may take time..." 
	 DetailPrint "Extracting $ISOFile to $EXEDIR\TEMPUUI" 
	 ExecWait '"$PLUGINSDIR\7zG.exe" x "$ISOFile" -o"$EXEDIR\TEMPUUI" -y'
	 
	 DetailPrint "Now copying AutoUnattend.xml"
     CopyFiles "$PLUGINSDIR\AutoUnattend.xml" "$EXEDIR\TEMPUUI\unattend.xml"
	 
	 CopyFiles "$PLUGINSDIR\dskvol.txt" "$DestDisk\dskvol.txt" 
     Call GetVolNameDSK 
     StrCpy $VHDDisk "$VHDDisk" 1
	 Delete "$DestDisk\dskvol.txt"

	    ${If} ${FileExists} "$EXEDIR\TEMPUUI\sources\install.wim" 
	        ${If} ${FileExists} "$WINDIR\System32\Dism.exe" 
	         DetailPrint "DISM will be used on install.wim"
			 !insertmacro ReplaceInFile "EXEDIR" "$EXEDIR" "all" "all" "$PLUGINSDIR\dismstuff.cmd" 
			 !insertmacro ReplaceInFile "USBDEV" "$VHDDisk" "all" "all" "$PLUGINSDIR\dismstuff.cmd" 
			 ExecWait 'cmd /c "$PLUGINSDIR\dismstuff.cmd"'
	         ; ExecWait '"cmd" /c Dism /Apply-Image /ImageFile:"$EXEDIR\TEMPUUI\sources\install.wim" /index:1 /ApplyDir:$VHDDisk:\'
	        ${Else}
			 DetailPrint "$WINDIR\System32\Dism.exe does not exist. We will use Wimlib."
		     ExecWait 'cmd /c "$PLUGINSDIR\wimlib\wimlib-imagex" apply "$EXEDIR\TEMPUUI\sources\install.wim" 1 $VHDDisk:\' 
	        ${EndIf}
	    ${EndIf}
	  
	    ${If} ${FileExists} "$EXEDIR\TEMPUUI\sources\install.esd" 
	        ${If} ${FileExists} "$WINDIR\System32\Dism.exe" 
	   	     DetailPrint "DISM will be used on install.esd"
			 !insertmacro ReplaceInFile "install.wim" "install.esd" "all" "all" "$PLUGINSDIR\dismstuff.cmd"  
			 !insertmacro ReplaceInFile "USBDEV" "$VHDDisk" "all" "all" "$PLUGINSDIR\dismstuff.cmd" 
			 !insertmacro ReplaceInFile "EXEDIR" "$EXEDIR" "all" "all" "$PLUGINSDIR\dismstuff.cmd"  
			 ExecWait 'cmd /c "$PLUGINSDIR\dismstuff.cmd"'
	         ; ExecWait '"cmd" /c Dism /Apply-Image /ImageFile:"$EXEDIR\TEMPUUI\sources\install.esd" /index:1 /ApplyDir:$VHDDisk:\'
	        ${Else}
			 DetailPrint "$WINDIR\System32\Dism.exe does not exist. We will use Wimlib."
		     ExecWait 'cmd /c "$PLUGINSDIR\wimlib\wimlib-imagex" apply "$EXEDIR\TEMPUUI\sources\install.esd" 1 $VHDDisk:\' 
	        ${EndIf}
	    ${EndIf}
	  
	  CopyFiles "$PLUGINSDIR\AutoUnattend.xml" "B:\unattend.xml"
	  nsExec::ExecToLog 'DiskPart /S "$PLUGINSDIR\diskpartdetach.txt"'  
	  
	  CopyFiles "$EXEDIR\TEMPUUI\$JustISOName.vhdx" "$BootDir\UUI\$DistroPath\$JustISOName.vhdx"
	  
	 ;; Delete "$EXEDIR\TEMPUUI\*.*"
	 RMDir /R "$EXEDIR\TEMPUUI"
	  
	 ;revert back in case of reuse during add additional distro
	 !insertmacro ReplaceInFile "$BootDir\UUI\$DistroPath\$JustISOName" "DSK" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt" 
	 !insertmacro ReplaceInFile "$JustISOName" "SLUG" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt" 
	 !insertmacro ReplaceInFile "$BootDir\UUI\$DistroPath\$JustISOName" "DSK" "all" "all" "$PLUGINSDIR\diskpartdetach.txt" 
	 !insertmacro ReplaceInFile "$JustISOName" "SLUG" "all" "all" "$PLUGINSDIR\diskpartdetach.txt"  
	 !insertmacro ReplaceInFile "ntfs" "VHDFMT" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt"  ; edit this to format type
	 !insertmacro ReplaceInFile "$VHDSize" "VHDSIZE" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt"  ; edit this to beyond the calculated filesize in bytes
	 !insertmacro ReplaceInFile "$VHDLBL" "VHDLBL" "all" "all" "$PLUGINSDIR\w2gdiskpart.txt"   	
	 
; For VDI
${ElseIf} $DistroName == "Ubuntu 22.04 Bootable VDI" 
${OrIf} $DistroName == "CentOS 7 Bootable VDI" 
  DetailPrint "Decompressing $JustISO to $BootDir\UUI\$DistroPath\"
  ExecWait '"$PLUGINSDIR\7zG.exe" x "$ISOFile" -o"$BootDir\UUI\$DistroPath\" -y'
	 
; For Memtest + zip extraction
${ElseIf} $DistroName == "Memtest86 (Memory Testing Tool)" 
${OrIf} $DistroName == "Memtest86+ (Memory Testing Tool)" 
  DetailPrint "Copying $JustISO to $BootDir\UUI\$DistroPath\"
  CopyFiles "$ISOFile" "$BootDir\UUI\$DistroPath\$JustISO" ; Copy to Directory
  DetailPrint "Extracting $JustISO from .zip" 
  ExecWait '"$PLUGINSDIR\7zG.exe" x "$ISOFile" -o"$BootDir\UUI\$DistroPath\" -y'
 
; For all other Distros, just copy the ISO to the container
${Else}
  DetailPrint "Copying $JustISO to $BootDir\UUI\$DistroPath\"
  CopyFiles "$ISOFile" "$BootDir\UUI\$DistroPath\$JustISO" ; Copy the ISO to Directory
${EndIf}

; Write the Path to Installed.txt
${If} $DistroName == "Phoenix LiteOS" 
  ${InstalledList} "$DistroPath\$JustISOName.vhdx" $R0 
${Else}
  ${InstalledList} "$DistroPath\$JustISO" $R0 ; Write the ISO path name to the Installed List "Installed.txt" file (so we can keep track of installs for removal)
${EndIf}

 ${LineFind} "$BootDir\UUI\Installed.txt" "$BootDir\UUI\Installed.txt" "1:-1" "DeleteEmptyLine" ; Remove any left over empty lines 

; Enable and Create Casper if necessary
${If} $Persistence != "NULL"
  ${If} $Casper != "0" ; Casper Slider (Size) was not Null
    Call CasperScript
  ${ElseIf} $CasperURL != "" ; user chose a size
    Call CasperScript
  ${EndIf}
${EndIf}
!macroend